let cart = [];
const cartCount = document.querySelector('.cart-count');
const cartItems = document.getElementById('cart-items');

const authModal = document.getElementById('auth-modal');
const cartModal = document.getElementById('cart-modal');
const loginBtn = document.getElementById('login-btn');
const cartBtn = document.getElementById('cart-btn');
const closeModals = document.querySelectorAll('.close-modal');

function updateCart() {
    cartCount.textContent = cart.length;
    
    if (cart.length === 0) {
        cartItems.innerHTML = `
            <div class="empty-cart-message">
                <i class="fas fa-shopping-bag"></i>
                <p>Ваша корзина пуста</p>
            </div>
        `;
    } else {
        cartItems.innerHTML = cart.map((item, index) => `
            <div class="cart-item">
                <img src="${item.image}" alt="${item.name}">
                <div class="cart-item-info">
                    <h4>${item.name}</h4>
                    <p>${item.category}</p>
                    <div class="cart-item-price">${item.price.toLocaleString('en-US', {style: 'currency', currency: 'USD'})}</div>
                </div>
                <button class="remove-from-cart" data-index="${index}">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        `).join('');
        
        document.querySelectorAll('.remove-from-cart').forEach(button => {
            button.addEventListener('click', (e) => {
                const index = parseInt(e.currentTarget.getAttribute('data-index'));
                removeFromCart(index);
            });
        });
    }
}

function addToCart(product) {
    cart.push(product);
    updateCart();
}

function removeFromCart(index) {
    cart.splice(index, 1);
    updateCart();
}

loginBtn.addEventListener('click', () => {
    authModal.style.display = 'flex';
});

cartBtn.addEventListener('click', () => {
    cartModal.style.display = 'flex';
});

closeModals.forEach(closeBtn => {
    closeBtn.addEventListener('click', () => {
        authModal.style.display = 'none';
        cartModal.style.display = 'none';
    });
});

window.addEventListener('click', (e) => {
    if (e.target === authModal) {
        authModal.style.display = 'none';
    }
    if (e.target === cartModal) {
        cartModal.style.display = 'none';
    }
});

document.querySelectorAll('.add-to-cart-btn, .add-to-cart').forEach(button => {
    button.addEventListener('click', (e) => {
        e.preventDefault();
        const productData = JSON.parse(button.getAttribute('data-product'));
        addToCart(productData);
        
        if (button.classList.contains('add-to-cart-btn')) {
            const originalText = button.textContent;
            button.textContent = 'Добавлено!';
            button.style.backgroundColor = '#28a745';

            setTimeout(() => {
                button.textContent = originalText;
                button.style.backgroundColor = '';
            }, 1500);
        }
    });
});

const mobileMenuBtn = document.querySelector('.mobile-menu-btn');
const nav = document.querySelector('nav');

mobileMenuBtn.addEventListener('click', () => {
    nav.classList.toggle('active');
});

const testimonials = document.querySelectorAll('.testimonial');
const dots = document.querySelectorAll('.testimonial-dot');
let currentTestimonial = 0;

function showTestimonial(index) {
    testimonials.forEach(testimonial => testimonial.classList.remove('active'));
    dots.forEach(dot => dot.classList.remove('active'));

    testimonials[index].classList.add('active');
    dots[index].classList.add('active');
    currentTestimonial = index;
}

dots.forEach((dot, index) => {
    dot.addEventListener('click', () => {
        showTestimonial(index);
    });
});

setInterval(() => {
    currentTestimonial = (currentTestimonial + 1) % testimonials.length;
    showTestimonial(currentTestimonial);
}, 5000);

document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
            target.scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
            nav.classList.remove('active');
        }
    });
});
